<?php
// Config - set your DB & SMTP
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'paypal_system';
$admin_email = 'admin@example.com';

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) die("DB connection failed: ".$conn->connect_error);

function generateTransactionID() {
    return 'TXN'.time().rand(1000,9999);
}

function sendEmail($to, $subject, $message, $headers='') {
    return mail($to, $subject, $message, $headers);
}

if(isset($_POST['send_payment'])){
    $sender_name = $_POST['sender_name'];
    $sender_email = $_POST['sender_email'];
    $receiver_name = $_POST['receiver_name'];
    $receiver_email = $_POST['receiver_email'];
    $amount = $_POST['amount'];
    $transaction_id = generateTransactionID();

    $stmt = $conn->prepare("INSERT INTO transactions 
        (sender_name,sender_email,receiver_name,receiver_email,amount,transaction_id) 
        VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("ssssds",$sender_name,$sender_email,$receiver_name,$receiver_email,$amount,$transaction_id);
    $stmt->execute();

    $admin_subject = "Payment Approval Needed: $transaction_id";
    $admin_message = "Payment from $sender_name ($sender_email) to $receiver_name ($receiver_email) of $$amount is pending. Approve via admin panel.";
    sendEmail($admin_email,$admin_subject,$admin_message);

    echo "Payment created and pending. Admin will approve.";
}

if(isset($_GET['approve'])){
    $transaction_id = $_GET['approve'];
    $stmt = $conn->prepare("UPDATE transactions SET status='Completed' WHERE transaction_id=?");
    $stmt->bind_param("s",$transaction_id);
    $stmt->execute();

    $res = $conn->query("SELECT * FROM transactions WHERE transaction_id='$transaction_id'");
    $txn = $res->fetch_assoc();

    $subject = "Payment Received: $transaction_id";
    $message = "Hi ".$txn['receiver_name'].",\n\nYou have received a payment.\nAmount: $".$txn['amount']."\nFrom: ".$txn['sender_name']." (".$txn['sender_email'].")\nTransaction ID: ".$txn['transaction_id']."\nStatus: ".$txn['status']."\nDate: ".$txn['created_at']."\n\nThank you.";
    sendEmail($txn['receiver_email'],$subject,$message);
    echo "Payment approved and receipt sent to recipient.";
}
?>

<h2>Create Payment</h2>
<form method="POST">
    Sender Name: <input type="text" name="sender_name" required><br>
    Sender Email: <input type="email" name="sender_email" required><br>
    Receiver Name: <input type="text" name="receiver_name" required><br>
    Receiver Email: <input type="email" name="receiver_email" required><br>
    Amount: <input type="number" step="0.01" name="amount" required><br>
    <button type="submit" name="send_payment">Send Payment</button>
</form>
